/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import noppes.npcs.Server;
import noppes.npcs.api.entity.data.IMark;
import noppes.npcs.api.handler.capability.IMarkDataHandler;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.data.Availability;

public class MarkData
implements IMarkDataHandler,
ICapabilityProvider {
    @CapabilityInject(value=IMarkDataHandler.class)
    public static Capability<IMarkDataHandler> CNPCS_MARKDATA_CAPABILITY = null;
    private static final ResourceLocation CNPCS_CAPKEY = new ResourceLocation("customnpcs", "markdata");
    public EntityLivingBase entity;
    public List<Mark> marks = new ArrayList<Mark>();

    public static MarkData get(EntityLivingBase entity) {
        if (!(entity.getCapability(CNPCS_MARKDATA_CAPABILITY, null) instanceof MarkData)) {
            return new MarkData();
        }
        MarkData data = (MarkData)entity.getCapability(CNPCS_MARKDATA_CAPABILITY, null);
        if (data != null && data.entity == null) {
            data.entity = entity;
            data.setNBT(entity.getEntityData().func_74775_l("cnpcmarkdata"));
        }
        return data;
    }

    public static void register(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(CNPCS_CAPKEY, (ICapabilityProvider)new MarkData());
    }

    public IMark addMark(int type) {
        Mark m = new Mark();
        m.type = type;
        this.marks.add(m);
        this.syncClients();
        return m;
    }

    public void addMark(int type, int color) {
        Mark m = new Mark();
        m.type = type;
        m.color = color;
        this.marks.add(m);
        this.syncClients();
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Mark m : this.marks) {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74768_a("type", m.type);
            c.func_74768_a("color", m.color);
            c.func_74782_a("availability", (NBTBase)m.availability.save(new NBTTagCompound()));
            c.func_74757_a("rotate", m.rotate);
            c.func_74757_a("is3d", m.is3d);
            list.func_74742_a((NBTBase)c);
        }
        compound.func_74782_a("marks", (NBTBase)list);
        return compound;
    }

    public IMark getNewMark() {
        return new Mark();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CNPCS_MARKDATA_CAPABILITY;
    }

    public void save() {
        this.entity.getEntityData().func_74782_a("cnpcmarkdata", (NBTBase)this.getNBT());
    }

    @Override
    public void setNBT(NBTTagCompound compound) {
        ArrayList<Mark> marks = new ArrayList<Mark>();
        NBTTagList list = compound.func_150295_c("marks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound c = list.func_150305_b(i);
            Mark m = new Mark();
            m.type = c.func_74762_e("type");
            m.color = c.func_74762_e("color");
            m.availability.load(c.func_74775_l("availability"));
            m.rotate = c.func_74767_n("rotate");
            m.is3d = c.func_74767_n("is3d");
            marks.add(m);
        }
        this.marks = marks;
    }

    public void syncClients() {
        if (this.entity == null || this.entity.field_70170_p == null || this.entity.field_70170_p.field_72995_K) {
            return;
        }
        Server.sendToAll(this.entity.func_184102_h(), EnumPacketClient.MARK_DATA, this.entity.func_145782_y(), this.getNBT());
    }

    public class Mark
    implements IMark {
        public Availability availability = new Availability();
        public int color = 16772433;
        public boolean rotate = false;
        public boolean is3d = false;
        public int type = 0;

        @Override
        public IAvailability getAvailability() {
            return this.availability;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public int getType() {
            return this.type;
        }

        public boolean is3D() {
            return this.is3d;
        }

        @Override
        public boolean isRotate() {
            return this.rotate;
        }

        public void set3D(boolean is3d) {
            this.is3d = is3d;
        }

        @Override
        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public void setRotate(boolean rotate) {
            this.rotate = rotate;
        }

        @Override
        public void setType(int type) {
            this.type = type;
        }

        @Override
        public void update() {
            MarkData.this.syncClients();
        }
    }
}

